# 谱聚类（spectral clustering）

https://www.cnblogs.com/pinard/p/6221564.html

[TOC]



## 概述

来自图论，对图进行切图后使不同的子图间边权重尽可能低而子图内边权重尽可能高，达到聚类的目的

## 基础一：无向权重图

$$
定义图为G=(V,E)，w_{i,j}为点v_i,v_j之间的权重。度定义为d_i=\sum_{j=1}^n{w_{ij}}，于是\\得到度矩阵，是一个对角矩阵。所有点之间的权重值得到图的邻接矩阵W。
$$

## 基础二：相似矩阵

如何得到邻接矩阵？构建邻接矩阵有三种方法：采用点间距离度量的相似矩阵得到
$$
一、\epsilon邻接法，设置距离阈值\epsilon，用欧式距离度量两点之间的关系。邻接矩阵定义为：\\
w_{ij}=0 \quad if s_{ij}>\epsilon \\
w_{ij}=\epsilon \quad if s_{ij}<=\epsilon
$$

$$
二、K邻接法，只要一个点在另一个点的K近邻中，则保留s_{ij}\\
w_{ij}=w_{ji}=0 \quad if x_i \in KNN(x_j) \ and\ x_j \in KNN(x_i)\\
w_{ij}=w_{ji}=exp(-\frac{{\vert {x_i-x_j} \vert}_2^2}{2{\sigma}^2}) \quad if x_i \in KNN(x_j) \ or\ x_j \in KNN(x_i)\\ 
$$

$$
或只有二者互为K近邻才能保留s_{ij}
$$

三、全连接法，相比前两种方法，这种方法的所有权重值都大于0，可以采用和函数定义边权重，常用的包括多项式和函数，高斯核函数和sigmoid和函数。最常用的是高斯核函数RBF，此时相似矩阵和邻接矩阵相同
$$
w_{ij}=s_{ij}=exp(-\frac{{\vert x_i-x_j \vert}_2^2}{2{\sigma}^2})
$$

## 基础三：拉普拉斯矩阵

$$
拉普拉斯矩阵L=D-W。对于任意向量f，我们有\\
f^TLf=\frac{1}{2}\sum_{i,j=1}^nw_{ij}(f_i-f_j)^2
$$

$$
f^TLf=f^TDf-f^TWf=\sum_{i=1}^nd_if_i^2-\sum_{i,j=1}^nw_{ij}f_if_j\\=\frac{1}{2}(\sum_{i=1}^nd_if_i^2-2\sum_{i,j=1}^nw_{ij}f{i}f{j}+\sum_{j=1}^nd_jf_j^2)=\frac{1}{2}\sum_{i,j=1}^nw_{ij}(f_i-f_j)^2
$$

## 基础四：无向图切图

$$
将无向图G的切为k个没有互相连接的子图，每个子图点的集合为A_1,A_2,...A_k。\\
它们满足A_i \bigcap A_j=\emptyset，且A_1\bigcup A_2\bigcup...A_k=V\\
定义A和B之间的切图权重为：\\
W(A,B)=\sum_{i \in A,j \in B}w_{ij}\\
对于所有子图点集合，定义切图cut：\\
cut(A_1,A_2,...,A_k)=\frac{1}{2}\sum_{i=1}^kW(A_i,\bar{A_i})
$$

## 切图聚类

### RatioCut

对于切图不光考虑最小化cut，同时考虑最大化每个子图的点数：
$$
RatioCut(A_1,A_2,..A_k)=\frac{1}{2}\sum_{i=1}^k \frac {W(A_i,\bar{A_i})}{\vert A_i \vert}
$$
考虑如何最小化Ratiocut函数，引入指示向量
$$
h_{ij}=0 \quad if \ v_i \notin \ A_j\\
h_{ij}=\frac{1}{\sqrt{\vert A_j \vert}} \quad i f\  v_i \in A_j
$$
故：
$$
h_i^TLh_i=\frac{1}{2}\sum_{m=1}\sum_{n=1}w_{mn}(h_{im}-h_{in})^2\\=\frac{1}{2}(\sum_{m \in A_i,n \notin A_i}w_{mn}(\frac{1}{\sqrt{\vert A_i \vert}}-0)^2)+\sum_{m \notin A_i,n \in A_i}w_{mn}(0-\frac{1}{\sqrt{\vert A_i \vert}})^2)\\=\frac{1}{2}(\sum_{m \in A_i,n \notin A_i}w_{mn}\frac{1}{\vert A_i \vert}+\sum_{m \notin A_i,n \in A_i}W_{mn}\frac{1}{\vert A_i\vert})\\=\frac{1}{2}(cut(A_i,\bar{A_i})\frac{1}{\vert A_i \vert}+cut(A_i,\bar{A_i})\frac{1}{\vert A_i \vert})\\=\frac{cut(A_i,\bar{A_i})}{\vert A_i\vert}
$$
所以有：
$$
RatioCut(A_1,A_2,..,A_k)=\sum_{i=1}^{k}h_i^TLh_i=tr(H^TLH)
$$
目标为找到L最小特征值，得到对应特征向量，此时对应二分效果图最佳。

### ncut

$$
定义col(A):=\sum_{i \in A}d_i
$$



将Ratiocut的分母换成vol(A)，同时对指示向量做了改进
$$
h_{ij}=\frac{1}{\sqrt{vol(A_i)}}
$$

$$
仍有h_i^TLh_I=\frac{cut(A_1,\bar{A_i})}{vol(A_i)}，故优化目标仍为上述
$$



## 谱聚类算法流程

注意点：相似矩阵的生成方式，切图方式，最后的聚类方法

